<?php

namespace Wolfie\Models;

use Illuminate\Database\Eloquent\Model;

class Message extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;
    protected $fillable = array('message_type', 'extra', 'body', 'image', 'read_ad', 'from_type', 'from_id', 'to_type', 'to_id');
    protected $visible = array('from_type', 'from_id', 'to_type', 'to_id');

    public function thread()
    {
        return $this->belongsTo('Thread', 'thread_id');
    }

    public function from()
    {
        return $this->morphTo();
    }

    public function to()
    {
        return $this->morphTo();
    }

}